/*****************************************************************************
*  LPC43xx SCT demo program
*
*  1. Use SCT timer to generate a 100 msec toggle output @ SCT_OUT0
*  2. SCT_OUT0 is at pin P4_2 (toggles every 100 msec)
*****************************************************************************/
#include "nxp_lpc43xx.h"
#include "mcb4300.h"

extern void SCT_Init(void);

int main (void) 
{
    SystemCoreClockUpdate ();                      // Update system core clock

    LPC_CCU1->CLK_M4_SCT_CFG  = (1 << 0);          // enable SCT clock in CCU1 

    MCB4300_Init();                                // Initialize MCB4300 board stuff
    SCT_Init();                                    // Initialize SCT1

    while (1) 
    {
    }
}
